#!/bin/bash
#   Insead of /bin/sh
# ffmpeg-wrapper.sh
#FFmpeg wrapper script for use with Refresh Plugin
# As repaired by ttguy 6 Oct 2012
# Make it a bash script instead of a sh script - so the [[ ]] extended test construct works
# Fixed line feeds
# fixed missing close quotes on the curl call (and added the closing </PARAMETER> tag and closing </action> tag)
#  added [[ ]] to the test for =="-i"

# Make it work if ffmpeg executable is not in the same folder as this script
# To do this you set  the FFmpegFOLDER variable below to the location of your ffmpeg executable. If it resides in the same folder as
# this ffmpeg-wrapper.sh then "." is valid
#  No trailing slash. ie "/usr/bin" not "/usr/bin/" 
# FFmpegFOLDER="."     
FFmpegFOLDER="/usr/bin"

PARAMS=""
INPUT=0
for PARAM in "$@"; do
  if [ ${INPUT} = 1 ]; then

    #if the url is of the format 'rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/vnnn/reflector:53708*'
    #extract VVAL from the url for Refresh-on-Demand (Refresh.groovy)
    VVAL="$PARAM"
    VVAL=`expr match "$VVAL" 'rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v\(.*\)/reflector:53708*'`
    if [[ ! -z "${VVAL}" ]]; then
      curl -X POST "http://localhost:23423/rest/action" -H "Content-Type: text/xml" -d "<action><name>forceOnlineResourceRefresh</name><parameter>${VVAL}</parameter></action>"
    fi

    #the FFmpeg input filename/URL needs quotes adding back on
    #because it may contain spaces, and the shell has removed them
    PARAMS="${PARAMS} \"${PARAM}\""
    INPUT=0
  else
    PARAMS="${PARAMS} ${PARAM}"
  fi
  if [[ "${PARAM}" == "-i" ]]; then
    #this loop is the -i parameter, the next loop will be the input filename/URL
    INPUT=1
  fi
done

#invoke FFmpeg
echo "${FFmpegFOLDER}/ffmpeg ${PARAMS}" > ../log/ffmpeg-wrapper.log
echo "${FFmpegFOLDER}/ffmpeg ${PARAMS}"
eval ${FFmpegFOLDER}/ffmpeg ${PARAMS}




#return FFmpeg status
echo $?
exit $?
